angular.module('mynotes.notestore', [])
    .factory('noteStore', function () {
        var notes = angular.fromJson(window.localStorage['notes'] || '[]');

        function persist(){
            window.localStorage['notes'] = angular.toJson(notes);
        }

        return {
            list: function () {
                return notes;
            },

            get: function (noteId) {
                var note = undefined;
                var found = false;
                for (var i = 0; i < notes.length && ! found; i++) {
                    if (notes[i].id == noteId) {
                        note = notes[i];
                        found = true;
                    }
                }

                return note;
            },

            update: function (newNote) {
                var found = false;
                for (var i = 0; i < notes.length && !found; i++) {
                    if (notes[i].id == newNote.id) {
                        notes[i] = newNote;
                        persist();
                        found = true;
                    }
                }
            },

            create: function (newNote) {
                notes.push(newNote);
                persist();
            },

            remove: function(noteId){
                var found = false;
                for (var i = 0; i < notes.length && !found; i++) {
                    if (notes[i].id == noteId) {
                        notes.splice(i,1);
                        persist();
                        found = true;
                    }
                }
            },

            move: function(note, fromIndex, toIndex){
                notes.splice(fromIndex, 1);
                notes.splice(toIndex,0,note);
                persist();
            }
        };
    });