/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.engine;

import android.os.Build;
import android.webkit.CookieManager;
import android.webkit.WebView;
import org.apache.cordova.ICordovaCookieManager;

class SystemCookieManager
implements ICordovaCookieManager {
    protected final WebView webView;
    private final CookieManager cookieManager;

    public SystemCookieManager(WebView webview) {
        this.webView = webview;
        this.cookieManager = CookieManager.getInstance();
        if (Build.VERSION.SDK_INT >= 21) {
            this.cookieManager.setAcceptThirdPartyCookies(this.webView, true);
        }
    }

    @Override
    public void setCookiesEnabled(boolean accept) {
        this.cookieManager.setAcceptCookie(accept);
    }

    @Override
    public void setCookie(String url, String value) {
        this.cookieManager.setCookie(url, value);
    }

    @Override
    public String getCookie(String url) {
        return this.cookieManager.getCookie(url);
    }

    @Override
    public void clearCookies() {
        this.cookieManager.removeAllCookie();
    }

    @Override
    public void flush() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.cookieManager.flush();
        }
    }
}

